#include "MoveablesManager.h"

#define MOVEABLES_COUNT	4	//We should never have more than 4 moveables on the screen at the one time


MoveablesManager::MoveablesManager()
{
	for (int i = 0; i < MOVEABLES_COUNT; i++)
	{
		//We set two of each moveable into the vector ready to be used
		moveables.push_back(new Mushroom());
		moveables[i]->setAlive(false);

		i++;

		moveables.push_back(new OneUp());
		moveables[i]->setAlive(false);
	}

}


MoveablesManager::~MoveablesManager()
{
	//When the constructor is called, every element in the moveables vector is deleted
	for (int i = 0; i < moveables.size(); i++)
	{
		delete moveables[i];
	}
}

void MoveablesManager::spawn(MySprite::SpriteType moveablesType, sf::Vector2f spawn)
{
	for (int i = 0; i < MOVEABLES_COUNT; i++)
	{
		if (!moveables[i]->isAlive())
		{
			if (moveables[i]->getSpriteType() == moveablesType)	//If the sprite type of the moveable matches the moveable we want to spawn
			{
				moveables[i]->setAlive(true);	//Set the moveable alive
				moveables[i]->setPosition(spawn);	//Set its position to the spawn position
				return;	//We've spawned what we need, no need to go through the rest of the loop so return
			}
		}
	}
}

void MoveablesManager::update(float dt, Mario* mario, ItemManager* itemManager)
{
	std::vector<GameItems*> items = itemManager->getItems();	//We get all the items the moveable can collide with
	
	for (int i = 0; i < MOVEABLES_COUNT; i++)
	{
		if (mario->isAlive())
		{
			if (moveables[i]->isAlive())
			{
				if (Collision::checkBoundingBox(mario, moveables[i]))	//If Mario collides with the moveable
				{
					moveables[i]->handleCollision(mario, dt);	//Handle the collision
				}

				else
				{
					for (int j = 0; j < items.size(); j++)	//For every game item
					{
						if (items[j]->isAlive())
						{
							if (Collision::checkBoundingBox(moveables[i], items[j]))	//If we collide with the game item
							{
								if (items[j]->getSpriteType() == MySprite::SpriteType::PipeSprite)	//If the game item is a pipe
								{
									moveables[i]->setVelocity(-(moveables[i]->getVelocity().x), moveables[i]->getVelocity().y);	//Invert the velocity (we know for a fact the pipe collision MUST be with the edge)
								}

								else if (items[j]->getSpriteType() == MySprite::SpriteType::BlockSprite)	//If the game item is a block
								{
									items[j]->handleCollision(moveables[i], dt);	//The block handles the collision
								}
							}
						}
					}
				}

				moveables[i]->update(dt);
			}
		}
	}
}

void MoveablesManager::render(sf::RenderWindow* window)
{
	for (int i = 0; i < moveables.size(); i++)
	{
		if (moveables[i]->isAlive())
		{
			window->draw(*moveables[i]);	//Draw the moveable
		}
	}
}

std::vector<Moveables*> MoveablesManager::getMoveables()
{	
	return moveables;	//Returns the moveables vector
}